<?php
// api.php — endpoints JSON P2P
require_once __DIR__.'/chain.php';
require_once __DIR__.'/config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: ' . ALLOW_ORIGIN);

$route = $_GET['route'] ?? '';

try {
  switch ($route) {
    case 'pool':
      echo json_encode(['ok'=>true, 'pending'=>get_pending($db)]);
      break;

    case 'block_add':
      $in = json_decode(file_get_contents('php://input'), true) ?? [];
      $txs = $in['transactions'] ?? [];
      $miner = $in['miner'] ?? '';
      $prev  = $in['prev_hash'] ?? '';
      $hash  = $in['hash'] ?? '';
      $nonce = (int)($in['nonce'] ?? 0);
      $difficulty = (int)($in['difficulty'] ?? 4);

      // Insère le bloc
      $stmt = $db->prepare("
        INSERT INTO blocks(timestamp, transactions, prev_hash, hash, nonce, miner, difficulty)
        VALUES (datetime('now'), :t, :p, :h, :n, :m, :d)
      ");
      $ok = $stmt->execute([
        ':t'=>json_encode($txs),
        ':p'=>$prev,
        ':h'=>$hash,
        ':n'=>$nonce,
        ':m'=>$miner,
        ':d'=>$difficulty
      ]);

      // Supprime les transactions correspondantes de pending
      foreach ($txs as $tx) {
        if (!empty($tx['payload_hash'])) {
          $db->prepare("DELETE FROM pending WHERE payload_hash=?")->execute([$tx['payload_hash']]);
        }
      }

      echo json_encode(['ok'=>$ok]);
      break;

    case 'tx_new':
      $in = json_decode(file_get_contents('php://input'), true) ?? [];
      $ok = add_pending_tx(
        $db,
        (string)($in['sender'] ?? ''),
        (string)($in['receiver'] ?? ''),
        (float)($in['amount'] ?? 0),
        (string)($in['pubkey'] ?? ''),
        (string)($in['signature'] ?? ''),
        (string)($in['created_at'] ?? date('Y-m-d H:i:s'))
      );
      echo json_encode(['ok'=>$ok]);
      break;

    case 'chain':
      echo json_encode(['ok'=>true, 'blocks'=>get_chain($db)]);
      break;

    case 'peers':
      echo json_encode(['ok'=>true, 'peers'=>list_peers($db)]);
      break;

    case 'peer_add':
      $in = json_decode(file_get_contents('php://input'), true) ?? [];
      $ok = !empty($in['url']) ? add_peer($db, (string)$in['url']) : false;
      echo json_encode(['ok'=>$ok]);
      break;

    case 'user_get':
      $username = $_GET['username'] ?? '';
      $address  = $_GET['address'] ?? '';
      $sql = "SELECT username, address, pubkey, privpem FROM users WHERE 1=1 ";
      $params = [];
      if ($username) { $sql .= "AND username=? "; $params[] = $username; }
      if ($address)  { $sql .= "AND address=? ";  $params[] = $address; }
      $stmt = $db->prepare($sql);
      $stmt->execute($params);
      $user = $stmt->fetch(PDO::FETCH_ASSOC);
	  if (!$user) {
		  echo json_encode(['ok'=>false, 'error'=>'Utilisateur pas trouvé']);
		  exit;
	  }
	  // Encodage en base64 pour ne pas casser le JSON
	  $user['privpem'] = base64_encode($user['privpem']);
      echo json_encode(['ok'=>true, 'user'=>$user]);
      break;

    case 'user_register':
      $in = json_decode(file_get_contents('php://input'), true) ?? [];
      $stmt = $db->prepare("
        INSERT OR IGNORE INTO users (username, password_hash, pubkey, privpem, address)
        VALUES (:u, :p, :pub, :priv, :addr)
      ");
      $ok = $stmt->execute([
        ':u' => (string)($in['username'] ?? ''),
        ':p' => (string)($in['password_hash'] ?? ''),
        ':pub' => (string)($in['pubkey'] ?? ''),
        ':priv' => (string)($in['privpem'] ?? ''),
        ':addr' => (string)($in['address'] ?? '')
      ]);
      echo json_encode(['ok'=>$ok]);
      break;

    default:
      echo json_encode(['ok'=>false, 'error'=>'unknown route']);
  }
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
