<?php
// crypto.php — gestion clés, signatures, adresses, payload canonique (stable)

function generate_keypair(string $password): array {
  $res = openssl_pkey_new([
    'private_key_bits' => 2048,
    'private_key_type' => OPENSSL_KEYTYPE_RSA
  ]);
  openssl_pkey_export($res, $privEnc, $password);           // PEM privé chiffré
  $pub = openssl_pkey_get_details($res)['key'];              // PEM public
  return [$pub, $privEnc];
}

function address_from_pubkey(string $pubPem): string {
  return substr(hash('sha256', $pubPem), 0, 40);             // 40 hexa lisibles
}

function unlock_private_pem(string $privEnc, string $password): ?string {
  $privRes = openssl_pkey_get_private($privEnc, $password);
  if (!$privRes) return null;
  // Exporter en PEM clair en mémoire de session pour signer sans garder le mot de passe
  openssl_pkey_export($privRes, $privPemClear, null);
  return $privPemClear;
}

function payload_canonical(string $sender, string $receiver, float $amount, string $created_at): string {
  // 8 décimales pour stabilité du hash/signature
  $amt = number_format($amount, 8, '.', '');
  return $sender . '|' . $receiver . '|' . $amt . '|' . $created_at;
}

function sign_payload(string $privPemClear, string $payload): string {
  $priv = openssl_pkey_get_private($privPemClear);
  openssl_sign($payload, $sig, $priv, OPENSSL_ALGO_SHA256);
  return base64_encode($sig);
}

function verify_signature(string $pubPem, string $payload, string $b64sig): bool {
  $ok = openssl_verify($payload, base64_decode($b64sig), $pubPem, OPENSSL_ALGO_SHA256);
  return $ok === 1;
}
