<?php
// db.php — connexion SQLite + schéma + PRAGMA robustesse
require_once __DIR__ . '/config.php';

try {
  $db = new PDO('sqlite:' . __DIR__ . '/data.db');
  $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $db->exec("PRAGMA journal_mode = WAL;");
  $db->exec("PRAGMA synchronous = NORMAL;");
  $db->exec("PRAGMA foreign_keys = ON;");
  $db->exec("PRAGMA busy_timeout = 3000;");
} catch (Throwable $e) {
  die("SQLite error: " . htmlspecialchars($e->getMessage()));
}

// --- Schéma propre ---
$db->exec("
CREATE TABLE IF NOT EXISTS users (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  username TEXT UNIQUE NOT NULL,
  password_hash TEXT NOT NULL,   -- mot de passe haché avec password_hash()
  pubkey TEXT NOT NULL,          -- clé publique PEM
  privpem TEXT NOT NULL,         -- clé privée PEM (ou chiffrée)
  address TEXT UNIQUE NOT NULL,  -- adresse = sha256(pub) tronquée
  created_at TEXT DEFAULT CURRENT_TIMESTAMP
);
");

$db->exec("
CREATE TABLE IF NOT EXISTS pending (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  sender TEXT NOT NULL,      -- adresse émetteur
  receiver TEXT NOT NULL,    -- adresse destinataire
  amount REAL NOT NULL CHECK(amount > 0),
  signature TEXT NOT NULL,   -- base64
  pubkey TEXT NOT NULL,      -- PEM public (vérif indépendante)
  created_at TEXT NOT NULL,
  payload_hash TEXT UNIQUE NOT NULL  -- anti-doublon
);
");

$db->exec("
CREATE TABLE IF NOT EXISTS blocks (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  timestamp TEXT NOT NULL,
  transactions TEXT NOT NULL,   -- JSON de la liste pending minée
  prev_hash TEXT NOT NULL,
  hash TEXT NOT NULL,
  nonce INTEGER NOT NULL,
  miner TEXT,                   -- adresse du mineur
  difficulty INTEGER NOT NULL
);
");

$db->exec("
CREATE TABLE IF NOT EXISTS peers (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  url TEXT UNIQUE NOT NULL,
  added_at TEXT DEFAULT CURRENT_TIMESTAMP
);
");
