<?php
require_once __DIR__.'/auth.php';
require_once __DIR__.'/chain.php';
require_once __DIR__.'/config.php';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  try {
    if (isset($_POST['action']) && $_POST['action']==='register') {
      $u = register_user($db, trim($_POST['username']), $_POST['password']);
      flash("Compte créé, avec cette adresse : {$u['address']}");
    }
    if (isset($_POST['action']) && $_POST['action']==='login') {
      $ok = login_user($db, trim($_POST['username']), $_POST['password']);
      flash($ok ? "Connecté" : "Identifiants invalides");
    }
    if (isset($_POST['logout'])) { logout_user(); flash("Déconnecté"); }

	if (isset($_POST['action']) && $_POST['action']==='new_tx' && current_user()) {
	  $me = current_user();
	  $sender   = $me['address'];
	  $receiver = trim($_POST['receiver']);
	  $amount   = (float)$_POST['amount'];

	  if ($receiver === '') {
		flash("Veuillez indiquer une adresse destinataire.");
	  } elseif ($sender === $receiver) {
		flash("Vous ne pouvez pas envoyer des fonds à votre propre adresse !");
	  } elseif ($amount <= 0) {
		flash("Le montant doit être supérieur à zéro.");
	  } else {
		$created  = date('Y-m-d H:i:s');
		$payload  = payload_canonical($sender, $receiver, $amount, $created);
		$signature= sign_payload($me['privpem'], $payload);
		$ok = add_pending_tx($db, $sender, $receiver, $amount, $me['pubkey'], $signature, $created);
		flash($ok ? "Transaction ajoutée" : "Transaction refusée (signature/adresse/format)");
	  }
	}

    if (isset($_POST['mine']) && current_user()) {
      $ok = mine_block($db, current_user()['address'], CHAIN_DIFFICULTY);
      flash($ok ? "Bloc miné" : "Rien à miner");
    }

    if (isset($_POST['action']) && $_POST['action']==='add_peer') {
      $ok = add_peer($db, trim($_POST['peer_url']));
      flash($ok ? "Pair ajouté" : "Pair invalide");
    }

    if (isset($_POST['broadcast'])) { broadcast_pending($db); flash("Transactions diffusées"); }
    if (isset($_POST['resolve']))   { $sw = resolve_conflicts($db); flash($sw ? "Chaîne remplacée" : "Déjà la meilleure chaîne"); }
  } catch (Throwable $e) {
    flash("Erreur : ".$e->getMessage());
  }
  post_redirect_self();
}

$me      = current_user();
$msg     = flash();
$pending = get_pending($db);
$blocksR = array_reverse(get_chain($db));
$peers   = list_peers($db);
$valid   = validate_chain($db);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>BLOCKCHAIN SVR</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="style.css" rel="stylesheet">
</head>

<body>
<nav class="navbar navbar-expand-lg bg-primary navbar-dark sticky-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">
      Cryptomonnaie <i class="bi bi-currency-bitcoin me-1"></i>
    </a>
    <span class="badge bg-light text-dark small d-none d-sm-inline">
      <?= $valid ? 'blockchaîne valide' : 'blockchaîne corrompue' ?>
    </span>
    <div class="ms-auto">
      <?php if(!$me): ?>
		<button class="btn btn-sm btn-outline-light me-1" data-bs-toggle="modal" data-bs-target="#loginModal">
		  <i class="bi bi-box-arrow-in-right"></i>
		  <span class="d-none d-sm-inline"> Connexion</span>
		</button>

		<button class="btn btn-sm btn-light text-primary" data-bs-toggle="modal" data-bs-target="#registerModal">
		  <i class="bi bi-person-plus"></i>
		  <span class="d-none d-sm-inline"> Créer compte</span>
		</button>
      <?php else: ?>
        <form method="post" class="d-inline">
          <button class="btn btn-sm btn-outline-light" name="logout">
            <i class="bi bi-box-arrow-right"></i> Déconnexion
          </button>
        </form>
      <?php endif; ?>
    </div>
  </div>
</nav>

<div class="container py-4">
  <?php if($msg): ?><div class="alert alert-info"><?= htmlspecialchars($msg) ?></div><?php endif; ?>

  <div class="row g-2">
    <!-- Colonne gauche -->
    <div class="col-lg-5">
      <div class="card p-3">
        <h5>Compte</h5>
        <?php if($me): ?>
          <p><span class="badge bg-success">Connecté</span> <strong><?= htmlspecialchars($me['username']) ?></strong></p>
          <p class="mb-1">Adresse :<br><code class="small"><?= $me['address'] ?></code></p>
          <details class="mb-2">
            <summary class="text-muted" style="cursor:pointer">Voir la clé publique</summary>
            <code class="small"><?= htmlspecialchars($me['pubkey']) ?></code>
          </details>
        <?php else: ?>
          <p class="text-muted">Veuillez vous connecter ou créer un compte via les boutons en haut de page.</p>
        <?php endif; ?>
      </div>

      <div class="card p-3 mt-4">
        <h5>Pairs</h5>
        <form method="post" class="row g-2 mb-2">
          <div class="col-8"><input class="form-control" name="peer_url" placeholder="https://exemple.com/crypto" required></div>
          <div class="col-4 d-grid"><button class="btn btn-outline-primary" name="action" value="add_peer">Ajouter</button></div>
        </form>
        <?php if(!$peers): ?>
          <p class="text-muted mb-2">Pas de pair disponible</p>
        <?php else: ?>
          <ul class="list-group small mb-2">
            <?php foreach($peers as $p): ?>
              <li class="list-group-item"><?= htmlspecialchars($p['url']) ?></li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
        <div class="d-grid gap-2">
          <form method="post"><button class="btn btn-secondary" name="resolve"><i class="bi bi-arrow-repeat"></i> Synchroniser</button></form>
        </div>
      </div>
    </div>

    <!-- Colonne droite -->
    <div class="col-lg-7">
      <div class="card p-3 mb-4">
        <h5>Transactions</h5>
        <?php if($me): ?>
          <form method="post" class="row g-2 mb-3">
            <div class="col-md-6"><input class="form-control" name="receiver" placeholder="Adresse destinataire" required></div>
            <div class="col-md-3"><input class="form-control" name="amount" type="number" step="0.00000001" placeholder="Montant" required></div>
            <div class="col-md-3 d-grid"><button class="btn btn-primary" name="action" value="new_tx">Ajouter</button></div>
          </form>
          <div class="d-flex gap-2 flex-wrap">
            <form method="post"><button class="btn btn-success" name="mine"><i class="bi bi-hammer"></i> Miner</button></form>
            <form method="post"><button class="btn btn-outline-secondary" name="broadcast"><i class="bi bi-wifi"></i> Diffuser</button></form>
          </div>
        <?php else: ?>
          <p class="text-muted">Connectez-vous pour créer et signer des transactions.</p>
        <?php endif; ?>

        <hr>
        <h6>Transactions en attente</h6>
        <?php if(!$pending): ?>
          <p class="text-muted">Aucune transaction</p>
        <?php else: ?>
          <ul class="list-group small">
            <?php foreach($pending as $i => $t): ?>
              <li class="list-group-item">
				  <?= $i > 0 ? '<br>>' : '>' ?>
                <strong><?= htmlspecialchars($t['receiver']) ?></strong>
                <span class="ms-2"><?= (float)$t['amount'] ?> Ƀ</span>
                <div><code class="small">sig: <?= htmlspecialchars(substr($t['signature'],0,28)) ?>...</code></div>
              </li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </div>

      <div class="card p-3">
        <h5>Blockchain (<?= count($blocksR) ?> blocs)</h5>
        <?php if(!$blocksR): ?>
          <p class="text-muted">Aucun bloc.</p>
        <?php else: foreach($blocksR as $b): $txs=json_decode($b['transactions'], true)??[]; ?>
          <div class="border rounded p-3 mb-3 bg-white">
            <div class="d-flex justify-content-between align-items-baseline flex-wrap">
              <div><span class="badge bg-dark">#<?= $b['id'] ?></span> <span class="text-muted"><?= htmlspecialchars($b['timestamp']) ?></span></div>
              <?php if($b['miner']): ?><span class="badge badge-soft mt-1">miner: <?= htmlspecialchars(strlen($b['miner']) > 27 ? substr($b['miner'], 0, 27) . '...' : $b['miner']) ?></span><?php endif; ?>
            </div>
            <!-- <div class="small text-muted">nonce: <?= (int)$b['nonce'] ?> — d=<?= (int)$b['difficulty'] ?></div> -->
            <p class="small mt-2 mb-2">
<?php foreach($txs as $i => $t): ?>
  <?php
    $meAddr = $me['address'] ?? null; // adresse du compte connecté
    $isSender = $meAddr && $t['sender'] === $meAddr;
    $isReceiver = $meAddr && $t['receiver'] === $meAddr;

    if ($isSender) {
      $label = "Envoyé à";
      $icon  = "bi bi-arrow-up-right text-danger";
      $target = $t['receiver'];
      $color = "text-danger";
    } elseif ($isReceiver) {
      $label = "Reçu de";
      $icon  = "bi bi-arrow-down-left text-success";
      $target = $t['sender'];
      $color = "text-success";
    } else {
      $label = "Externe";
      $icon  = "bi bi-arrow-left-right text-secondary";
      $target = $t['receiver'];
      $color = "text-muted";
    }
  ?>
  <?= $i > 0 ? '<br>' : '' ?>
  <i class="<?= $icon ?>"></i>
  <span class="<?= $color ?> fw-semibold"><?= $label ?></span>
  <?= htmlspecialchars($target) ?> :
  <strong class="<?= $color ?>"><?= (float)$t['amount'] ?> Ƀ</strong>
<?php endforeach; ?>

            </p>
            <div class="small">
              <div><code class="small">prev: <?= htmlspecialchars(substr($b['prev_hash'],0,42)) ?>...</code></div>
              <div><code class="small">hash: <?= htmlspecialchars(substr($b['hash'],0,42)) ?>...</code></div>
            </div>
          </div>
        <?php endforeach; endif; ?>
      </div>
    </div>
  </div>

  <footer class="mt-5 text-center text-muted small">
    MVP éducatif — PHP + SQLite — Signatures RSA — Proof of Work — Consensus
  </footer>
</div>

<!-- === Modals === -->
<!-- Modal inscription -->
<div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="registerModalLabel"><i class="bi bi-person-plus"></i> Créer un compte</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fermer"></button>
      </div>
      <form method="post">
        <div class="modal-body">
          <input class="form-control mb-2" name="username" placeholder="Nom d'utilisateur" required>
          <input class="form-control mb-2" type="password" name="password" placeholder="Mot de passe" required>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Annuler</button>
          <button class="btn btn-primary" name="action" value="register">Créer</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal connexion -->
<div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title" id="loginModalLabel"><i class="bi bi-box-arrow-in-right"></i> Connexion</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fermer"></button>
      </div>
      <form method="post">
        <div class="modal-body">
          <input class="form-control mb-2" name="username" placeholder="Nom d'utilisateur" required>
          <input class="form-control mb-2" type="password" name="password" placeholder="Mot de passe" required>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Annuler</button>
          <button class="btn btn-primary" name="action" value="login">Se connecter</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
