from ecdsa import SigningKey, SECP256k1

def main():
    sk = SigningKey.generate(curve=SECP256k1)
    vk = sk.verifying_key
    with open("private_key.pem", "wb") as f:
        f.write(sk.to_pem())
    with open("public_key.pem", "wb") as f:
        f.write(vk.to_pem())
    print("Clés générées : private_key.pem / public_key.pem")

if __name__ == "__main__":
    main()
